unit IWCompCheckbox32;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  {$ELSE}
  {$IFDEF Linux}QControls, {$ELSE}Controls, {$ENDIF}
  {$ENDIF}
  {$IFDEF Linux}QGraphics, {$ELSE}Graphics, {$ENDIF}
  Classes,
  IWControl32, IWHTMLTag, IWRenderContext, IWBaseInterfaces;

type
  TIWCustomCheckBox32 = class(TIWCustomControl32, IIWInputControl)
  protected
    FChecked: Boolean;

    procedure SetValue(const AValue: string); virtual;
    procedure SetChecked(const AValue: Boolean);
    procedure InitControl; override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;

    property Checked: Boolean read FChecked write SetChecked;
  published

    property Caption;
    property ExtraTagParams;
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
    property TabOrder;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWCheckBox32.bmp}
  TIWCheckBox32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWCheckBox32), 'TIWCheckBox32.bmp')]
  {$ENDIF}
  TIWCheckBox32 = class(TIWCustomCheckBox32)
  published
    {$IFDEF VSNET}
    [Bindable(true)]
    {$ENDIF}  
    property Checked;
  end;

implementation

uses
  SysUtils,
  SWSystem;

{ TIWCustomCheckBox32 }

procedure TIWCustomCheckBox32.InitControl;
begin
  inherited;
  FNeedsFormTag := True;
  Height := 21;
  Width := 121;
end;

function TIWCustomCheckBox32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  Result := TIWHTMLTag.CreateTag('INPUT');
  try
    Result.AddStringParam('TYPE', 'CHECKBOX');
    Result.Add(iif(FChecked, 'CHECKED'));
    Result.AddStringParam('NAME', HTMLName);
    Result.Contents.AddTagAsObject(WebFont.FontToStringTag32(Caption));
  except
    FreeAndNil(Result);
    raise;
  end;

  // uncheck it explicitely, cause unchecked checkbox's param
  // is not sent by the browser
  SetChecked( false );
end;

procedure TIWCustomCheckBox32.SetChecked(const AValue: Boolean);
begin
  FChecked := AValue;
  Invalidate;
end;

procedure TIWCustomCheckBox32.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  FChecked := AnsiSameText(AValue, 'On');
  Invalidate;
end;

end.
